﻿IF OBJECT_ID(N'[dbo].[FK_GF_ResponseGF_ResponseField]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_ResponseField] DROP CONSTRAINT [FK_GF_ResponseGF_ResponseField];
GO
IF OBJECT_ID(N'[dbo].[FK_PrincipalGF_Response]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_Response] DROP CONSTRAINT [FK_PrincipalGF_Response];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_FieldGF_Response]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_Response] DROP CONSTRAINT [FK_GF_FieldGF_Response];
GO

-- Delete response tabels
IF OBJECT_ID(N'[dbo].[GF_Response]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_Response];
GO
IF OBJECT_ID(N'[dbo].[GF_ResponseField]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_ResponseField];
GO

-- Creating table 'GF_Response'
CREATE TABLE [dbo].[GF_Response] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Score] int  NOT NULL,
    [AllCorrect] bit  NOT NULL,
    [Principal_PrincipalID] int  NOT NULL,
    [GF_Quiz_Id] int  NOT NULL
);
GO

-- Creating table 'GF_ResponseField'
CREATE TABLE [dbo].[GF_ResponseField] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Value] nvarchar(max)  NOT NULL,
    [FieldId] int  NOT NULL,
    [GF_Response_Id] int  NOT NULL
);
GO

-- Creating primary key on [Id] in table 'GF_Response'
ALTER TABLE [dbo].[GF_Response]
ADD CONSTRAINT [PK_GF_Response]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_ResponseField'
ALTER TABLE [dbo].[GF_ResponseField]
ADD CONSTRAINT [PK_GF_ResponseField]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO



-- Creating foreign key on [GF_Response_Id] in table 'GF_ResponseField'
ALTER TABLE [dbo].[GF_ResponseField]
ADD CONSTRAINT [FK_GF_ResponseGF_ResponseField]
    FOREIGN KEY ([GF_Response_Id])
    REFERENCES [dbo].[GF_Response]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_ResponseGF_ResponseField'
CREATE INDEX [IX_FK_GF_ResponseGF_ResponseField]
ON [dbo].[GF_ResponseField]
    ([GF_Response_Id]);
GO

-- Creating foreign key on [Principal_PrincipalID] in table 'GF_Response'
ALTER TABLE [dbo].[GF_Response]
ADD CONSTRAINT [FK_PrincipalGF_Response]
    FOREIGN KEY ([Principal_PrincipalID])
    REFERENCES [dbo].[Principal]
        ([PrincipalID])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PrincipalGF_Response'
CREATE INDEX [IX_FK_PrincipalGF_Response]
ON [dbo].[GF_Response]
    ([Principal_PrincipalID]);
GO


-- Creating foreign key on [GF_Quiz_Id] in table 'GF_Response'
ALTER TABLE [dbo].[GF_Response]
ADD CONSTRAINT [FK_GF_QuizGF_Response]
    FOREIGN KEY ([GF_Quiz_Id])
    REFERENCES [dbo].[GF_Quiz]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_QuizGF_Response'
CREATE INDEX [IX_FK_GF_QuizGF_Response]
ON [dbo].[GF_Response]
    ([GF_Quiz_Id]);
GO




